<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
error_reporting(E_ALL);
ini_set('display_errors', 'On');
header('Content-Type: application/json');

$conn=mysqli_connect('localhost','eprofitify_admin','V+H{Rb%{m7f%','eprofitify_db');

$method = $_SERVER['REQUEST_METHOD'];
$data = json_decode(file_get_contents('php://input'), true);

// Extract values
$email = $data['email'] ?? null;
$endpoint = $data['endpoint'] ?? null;
$publicKey = $data['publicKey'] ?? null;
$authToken = $data['authToken'] ?? null;
$contentEncoding = $data['contentEncoding'] ?? null;

if (!$email || !$endpoint) {
    error_log("Missing email or endpoint. Email: " . var_export($email, true) . ", Endpoint: " . var_export($endpoint, true));
    http_response_code(400);
    echo json_encode(['error' => 'Email and endpoint are required.']);
    exit;
}

switch ($method) {
    case 'POST': // Add a new subscription
        $result = mysqli_query($conn, "SELECT `fcm_token` FROM `users` WHERE `email` = '" . mysqli_real_escape_string($conn, $email) . "'");
        if ($row = mysqli_fetch_assoc($result)) {
            $tokens = json_decode($row['fcm_token'] ?? '[]', true);

            $newSubscription = [
                'endpoint' => $endpoint,
                'publicKey' => $publicKey,
                'authToken' => $authToken,
                'contentEncoding' => $contentEncoding
            ];

            // Check if endpoint already exists
            $exists = false;
            foreach ($tokens as $token) {
                if ($token['endpoint'] === $endpoint) {
                    $exists = true;
                    break;
                }
            }

            if (!$exists) {
                $tokens[] = $newSubscription;
                $update = mysqli_query($conn, "UPDATE `users` SET `fcm_token` = '" . mysqli_real_escape_string($conn, json_encode($tokens)) . "' WHERE `email` = '" . mysqli_real_escape_string($conn, $email) . "'");
                echo $update ? 'Subscription added.' : 'Database update failed.';
            } else {
                echo 'Subscription already exists.';
            }
        } else {
            echo 'User not found.';
        }
        break;

    case 'PUT': // Update subscription
        $result = mysqli_query($conn, "SELECT `fcm_token` FROM `users` WHERE `email` = '" . mysqli_real_escape_string($conn, $email) . "'");
        if ($row = mysqli_fetch_assoc($result)) {
            $tokens = json_decode($row['fcm_token'] ?? '[]', true);
            $updated = false;
            foreach ($tokens as &$token) {
                if ($token['endpoint'] === $endpoint) {
                    $token['publicKey'] = $publicKey;
                    $token['authToken'] = $authToken;
                    $token['contentEncoding'] = $contentEncoding;
                    $updated = true;
                    break;
                }
            }

            if ($updated) {
                $update = mysqli_query($conn, "UPDATE `users` SET `fcm_token` = '" . mysqli_real_escape_string($conn, json_encode($tokens)) . "' WHERE `email` = '" . mysqli_real_escape_string($conn, $email) . "'");
                echo $update ? 'Subscription updated.' : 'Failed to update subscription.';
            } else {
                echo 'Subscription not found.';
            }
        } else {
            echo 'User not found.';
        }
        break;

    case 'DELETE': // Remove a subscription
        $result = mysqli_query($conn, "SELECT `fcm_token` FROM `users` WHERE `email` = '" . mysqli_real_escape_string($conn, $email) . "'");
        if ($row = mysqli_fetch_assoc($result)) {
            $tokens = json_decode($row['fcm_token'] ?? '[]', true);
            $filtered = array_values(array_filter($tokens, function ($token) use ($endpoint) {
                return $token['endpoint'] !== $endpoint;
            }));

            if (count($filtered) !== count($tokens)) {
                $update = mysqli_query($conn, "UPDATE `users` SET `fcm_token` = '" . mysqli_real_escape_string($conn, json_encode($filtered)) . "' WHERE `email` = '" . mysqli_real_escape_string($conn, $email) . "'");
                echo $update ? 'Subscription removed.' : 'Failed to update subscriptions.';
            } else {
                echo 'Subscription not found.';
            }
        } else {
            echo 'User not found.';
        }
        break;

    default:
        echo 'Unhandled method.';
        break;
}
