<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
$subscription = json_decode(file_get_contents('php://input'), true);

if (!isset($subscription['endpoint'])) {
    echo 'Error: not a subscription';
    return;
}

$method = $_SERVER['REQUEST_METHOD'];
$filePath = __DIR__ . '/subscription.json';

// Load existing subscriptions from file
$subscriptions = file_exists($filePath) ? json_decode(file_get_contents($filePath), true) : [];

switch ($method) {
    case 'POST':
        // Add new subscription if not already present
        $found = false;
        foreach ($subscriptions as $sub) {
            if ($sub['endpoint'] === $subscription['endpoint']) {
                $found = true;
                break;
            }
        }

        if (!$found) {
            $subscriptions[] = $subscription;
            file_put_contents($filePath, json_encode($subscriptions, JSON_PRETTY_PRINT));
            echo 'Subscription added.';
        } else {
            echo 'Subscription already exists.';
        }
        break;

    case 'PUT':
        // Update existing subscription
        $updated = false;
        foreach ($subscriptions as &$sub) {
            if ($sub['endpoint'] === $subscription['endpoint']) {
                $sub = $subscription; // Replace with new subscription data
                $updated = true;
                break;
            }
        }

        if ($updated) {
            file_put_contents($filePath, json_encode($subscriptions, JSON_PRETTY_PRINT));
            echo 'Subscription updated.';
        } else {
            echo 'Subscription not found.';
        }
        break;

    case 'DELETE':
        // Remove subscription
        $newSubscriptions = array_filter($subscriptions, function ($sub) use ($subscription) {
            return $sub['endpoint'] !== $subscription['endpoint'];
        });

        if (count($newSubscriptions) !== count($subscriptions)) {
            file_put_contents($filePath, json_encode(array_values($newSubscriptions), JSON_PRETTY_PRINT));
            echo 'Subscription deleted.';
        } else {
            echo 'Subscription not found.';
        }
        break;

    default:
        echo "Error: method not handled";
        return;
}
