<?php
header("Access-Control-Allow-Origin: *"); // Allow all origins
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
error_reporting(E_ALL);
ini_set('display_errors', 'On');
require __DIR__ . '/../vendor/autoload.php';

use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

// Load subscriptions from file
$subscriptionFile = './admin_subscription.json';
if (!file_exists($subscriptionFile)) {
    echo "No subscriptions found.";
    exit;
}

$title = isset($_POST['title']) ? $_POST['title'] : 'e{Profitify} Admin Notification!';
$message = isset($_POST['message']) ? $_POST['message'] : 'Something Went Wrong. Please Contact to Developer!';
$url = isset($_POST['url']) ? $_POST['url'] : 'https://admin.eprofitify.com/';


$subscriptionsData = json_decode(file_get_contents($subscriptionFile), true);
if (empty($subscriptionsData)) {
    echo "No subscriptions to notify.";
    exit;
}

// VAPID keys
$auth = [
    'VAPID' => [
        'subject' => 'https://github.com/Minishlink/web-push-php-example/',
        'publicKey' => file_get_contents(__DIR__ . '/../keys/public_key.txt'),
        'privateKey' => file_get_contents(__DIR__ . '/../keys/private_key.txt'),
    ],
];

$webPush = new WebPush($auth);
$message = str_replace(["\\r", "\\n"], ["\r", "\n"], $message);
// Message to send
$payload = json_encode([
    'title' => $title,
    'message' => $message,
    'icon' => 'https://eprofitify.com/eprofitify-logo.png',
    'url' => $url
]);


// Send to each subscription
foreach ($subscriptionsData as $data) {
    $subscription = Subscription::create($data);

    $report = $webPush->sendOneNotification($subscription, $payload);

    $endpoint = $report->getRequest()->getUri()->__toString();
    if ($report->isSuccess()) {
        $results[] = ["endpoint" => $endpoint, "status" => "success"];
    } else {
        $results[] = ["endpoint" => $endpoint, "status" => "failed", "reason" => $report->getReason()];
    }
}

header('Content-Type: application/json');
echo json_encode([
    'status' => 'success',
    'results' => $results
]);
