<?php
error_reporting(E_ALL);
ini_set('display_errors', 'On');
require __DIR__ . '/../vendor/autoload.php';

use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

// Load subscriptions from file
$subscriptionFile = './subscription.json';
if (!file_exists($subscriptionFile)) {
    echo "No subscriptions found.";
    exit;
}

$subscriptionsData = json_decode(file_get_contents($subscriptionFile), true);
if (empty($subscriptionsData)) {
    echo "No subscriptions to notify.";
    exit;
}

// VAPID keys
$auth = [
    'VAPID' => [
        'subject' => 'https://github.com/Minishlink/web-push-php-example/',
        'publicKey' => file_get_contents(__DIR__ . '/../keys/public_key.txt'),
        'privateKey' => file_get_contents(__DIR__ . '/../keys/private_key.txt'),
    ],
];

$webPush = new WebPush($auth);

// Message to send
$payload = json_encode([
    'title' => 'New message from Instamessenger',
    'message' => 'Hello! 👋 This is for testing',
    'icon' => 'https://eprofitify.com/eprofitify-logo.png',
    'url' => 'https://eprofitify.com/template-preview.php'
    ]);

// Send to each subscription
foreach ($subscriptionsData as $data) {
    $subscription = Subscription::create($data);

    $report = $webPush->sendOneNotification($subscription, $payload);

    $endpoint = $report->getRequest()->getUri()->__toString();
    if ($report->isSuccess()) {
        echo "[v] Message sent successfully for subscription {$endpoint}.\n";
    } else {
        echo "[x] Failed to send message for subscription {$endpoint}: {$report->getReason()}\n";
    }
}
